﻿CREATE OR REPLACE FUNCTION CREATETABLE() 
RETURNS VOID AS 
$BODY$ 
DECLARE
	MSGFINAL TEXT := 'FOI CRIADA';
BEGIN 
	IF NOT EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS 
						WHERE TABLE_NAME= 'est_orc_pbm') THEN 

		CREATE TABLE est_orc_pbm(
			cd_emp	integer NOT NULL DEFAULT 0,
			cd_filial	integer NOT NULL DEFAULT 0,
			cd_orc	integer NOT NULL DEFAULT 0,
			id_terminal CHARACTER VARYING(200) NOT NULL,
			nsu_req NUMERIC NOT NULL,
			numero_sessao CHARACTER VARYING(50) NOT NULL,
			CONSTRAINT EST_ORC_PBM_PKEY PRIMARY KEY (cd_emp,cd_filial,cd_orc),
			CONSTRAINT EST_ORC_PBM_FKEY FOREIGN KEY (cd_emp,cd_filial,cd_orc)
			  REFERENCES est_orc (cd_emp,cd_filial,cd_orc) MATCH SIMPLE
			  ON UPDATE NO ACTION ON DELETE NO ACTION
			)
			WITH (OIDS=FALSE);
	ELSE    
		MSGFINAL := 'A TABELA JÁ EXISTE';
	END IF;

	RAISE NOTICE 'TABELA EST_ORC_PBM %', MSGFINAL::VARCHAR;

END; 
-- FIM BLOCO PRINCIPAL 
$BODY$ 
LANGUAGE PLPGSQL VOLATILE 
  COST 100; 
ALTER FUNCTION CREATETABLE() OWNER TO POSTGRES;
SELECT CREATETABLE(); 
DROP FUNCTION CREATETABLE();